const body = document.querySelector('body');
const inputs = document.querySelectorAll('.imageSize input')
const clipBoard = document.querySelector('#clipboard');
const downloadBtn = document.querySelector('#downloadBtn');

const pleaseWait = document.querySelector('.please-wait-div');
const counterEl = document.querySelector('.percentDisplay');
const barEl = document.querySelector('.loading-bar-front');

const imageContainer = document.querySelector('.imageContainer');

const images = {};
const imageArray = [];
const indexArray = [];
const imageChecks = 85;
let startingReference;



inputs.forEach(input => {
  input.onkeyup = () => {
    input.value = input.value.replace('.', '')
  }
})

document.querySelector('#form').onsubmit = (e) => {
  e.preventDefault()
  e.stopPropagation()
  //  check for empty input fields
  let empty = false
  inputs.forEach(input => {
    if (!input.value) {
      input.style.outline = '2px solid red'
      empty = true
      input.onkeydown = (e) => {
        if (e.key >= 0 || e.key <= 9) input.style.outline = 'none'
      }
    }
  })
  if (!empty) startSearch()
}

function startSearch() {
  document.querySelectorAll('input').forEach(input => {input.blur()})
  startingReference = 0;
  pleaseWait.style.display = 'block';
  imageContainer.innerHTML = '';
  // for (const image in images) delete images[image];
  // imageArray.length = 0;
  loadUnsplash();
}

function loadUnsplash() {
  const width = inputs[0].value
  const height = inputs[1].value
  const refPad0 = startingReference.toString().padStart(3, '0');
  const src = `https://unsplash.it/${width}/${height}?image=1` + refPad0;
  getImage(refPad0, src);
}

// loadEachImage()

function getImage(refNum, src) {
  startingReference++;
  const img = document.createElement('img');

  img.onload = function () {
    imageArray.push(['1' + refNum, img, src]);
    images[refNum] = {
      img: img,
      src: src,
    };
    console.log('loaded')
    checkProgress();
  };

  img.onerror = function (e) {
    e.preventDefault()
    console.log('error')
    checkProgress();
  };

  try {
    img.src = src; // fires off loading of image
  } catch (err) {
    console.warn(err)
  }
}

function checkProgress() {
  const percent = Math.floor((startingReference / imageChecks) * 100);
  counterEl.innerText = percent + '%';
  barEl.style.width = percent + '%';
  if (startingReference <= imageChecks) loadUnsplash();
  else filesDownloaded();
}

function filesDownloaded() {
  pleaseWait.style.display = 'none';
  counterEl.innerText = '0%';
  barEl.style.width = '0%';
  for (const image in images) {
    const div = document.createElement('div');
    div.classList.add('image');
    div.setAttribute('data-index', image);
    div.appendChild(images[image].img);

    const checkBox = document.createElement('input');
    checkBox.type = 'checkbox';
    div.appendChild(checkBox);

    div.onclick = function (e) {
      if (e.target.type != 'checkbox') checkBox.click();
    };

    checkBox.onclick = () => createIndexArray();
    imageContainer.appendChild(div);
  }
}

function createIndexArray() {
  //  This happens each time a pic is checked or unchecked
  indexArray.length = 0;
  imgElements = '';
  imageContainer.childNodes.forEach((child) => {
    if (child.querySelector('input').checked) {
      const index = child.getAttribute('data-index');
      //  This is an alternate for writing to clipBoard
      indexArray.push(index);

      // <img src="https://unsplash.it/400/400?image=1002">
      imgElements += `<img src="${images[index].src}"></img>\n`;
    }
  });

  if (indexArray.length > 0) {
    //  change clipBoard image to black when a pic is checked
    clipBoard.style.opacity = 1;
    downloadBtn.style.opacity = 1;
    clipBoard.onclick = () => {
      //  This is just the index values for each pick
      console.log(indexArray);
      // navigator.clipboard.writeText('[' + indexArray + ']');
      navigator.clipboard.writeText(imgElements);
      // const copiedMsg = document.getElementById('htmlCopied')
      // copiedMsg.style.visibility = 'visible'
      // setTimeout(() => {
      //   copiedMsg.style.visibility = 'hidden'
      // }, 1000);
      
    };

    downloadBtn.onclick = () => {
      console.log('start downloading...')
      // images.forEach(image => {})
      const downloadImages = document.querySelectorAll('input:checked')
      const downloadIndexes = []
      downloadImages.forEach(image => {
          // downloadIndexes.push(image.parentElement.dataset.index)
        const imageNum = image.parentElement.dataset.index
        console.log(images[imageNum].src)
        console.log('image_' + imageNum)
        downloadImage(images[imageNum].src, 'image_' + imageNum)
      })
      console.log(downloadIndexes)

    }
  } else {
    //  change clipBoard image to really light grey when no pics are clicked
    clipBoard.style.opacity = .2
    downloadBtn.style.opacity = .2
    clipBoard.onclick = null
    downloadBtn.onclick = null
  }
}

async function downloadImage(
  imageSrc,
  nameOfDownload = 'my-image.png',
) {
  const response = await fetch(imageSrc);

  const blobImage = await response.blob();

  const href = URL.createObjectURL(blobImage);

  const anchorElement = document.createElement('a');
  anchorElement.href = href;
  anchorElement.download = nameOfDownload;

  document.body.appendChild(anchorElement);
  anchorElement.click();

  document.body.removeChild(anchorElement);
  window.URL.revokeObjectURL(href);
}


// <img src="https://unsplash.it/400/400?image=1000"></img>
// <img src="https://unsplash.it/400/400?image=1001"></img>
