import { fancyDownloadingMsg, bump } from './messages.js';
fancyDownloadingMsg(loadingAssets, 'Please wait...');

import * as btns from './btns_&_checkboxes.js';
btns.init();
btns.toFront();
import {
  settings,
  checkBoxes,
  initRadioBtns,
  initCheckListeners,
  renderFonts,
  saveNewSettings,
  createWeightsTable,
} from './helpers.js';

//  card-front - main displays
const topMsg = document.getElementById('topMsg');
topMsg.innerHTML = document.querySelector('template.topMsg').innerHTML;
const sampleText = document.getElementById('sampleText');
const filesDiv = document.getElementById('files');
//  sizeInPxEl is the message that appears when scrolling over the sample text
const sizeInPxEl = document.querySelector('.sizeInPx');

//  card-front - buttons
export const downloadFileBtn = document.getElementById('downloadFileBtn');

const weightsTable = document.getElementById('weightsTable');
weightsTable.style.display = 'none';

const downloadProgram = document.querySelector('.downloadApplication');

downloadProgram.onclick = () => {
  fancyDownloadingMsg(downloadProgram, 'Downloading . . .');
  //  create the zip file within download_program.php
  fetch('./php/download_program.php').then((res) => {
    if (res.ok) {
      // window.open('zip_files/source_code.zip');
      const aTag = document.createElement('a');
      aTag.href = 'zip_files/source_code.zip';
      document.body.appendChild(aTag);
      aTag.click(); //  cause file to download
      aTag.remove(); //  remove <a> tag once file is downloaded
      //  Give a few seconds after the aTag is clicked
      setTimeout(() => {
        clearInterval(bump.bump);
        downloadProgram.innerHTML = '';
        setTimeout(() => {
          downloadProgram.innerHTML = 'Download Program';
          downloadProgram.classList.remove('active');
        }, 500);
      }, 3000);
    }
    // if (res.ok) return res.text();
  });
};

//  Store the data for each font from data.json files
export const fontInfo = [];

//  Default text can be changed here if I decide to
let defaultSampleText = '<div>This is some</div><div>sample text</div>';
settings.currentText = defaultSampleText;

btns.fontWeightDiv.innerText = settings.weight;
sampleText.style.fontSize = settings.size + 'px';

//       !!!  Not being used until copy links is functional  !!!
//  This initializes the first two settings with radio button functionality
// initRadioBtns([checkBoxes[0], checkBoxes[1]], showHideFileDownloadBtn);

function showHideFileDownloadBtn(radioButton) {
  if (radioButton.id == 'downloadFile')
    //  if it is set to download the file (not just the link), then...
    downloadFileBtn.parentElement.style.display = 'block';
  else downloadFileBtn.parentElement.style.display = 'none';
  saveNewSettings();
}

//  This initializes the storage choices with radio button functionality
initRadioBtns(
  [...document.getElementsByClassName('storageType')],
  saveNewSettings
);

//  This initializes 'onclick' for all the other 'non-radio' checkboxes
initCheckListeners();

//  This initializes the wheel event to change the font-size,
//    the other wheel functions (letter, word & margin) are set
//    when the l, w or m keys are pressed and held, respectively.
changeProperty(['size', '--fontSize', 0, 100, 'Font Size: ']);

{
  //  this only happens once on startup - const savedValues is scoped with {}
  const savedValues = JSON.parse(localStorage.getItem('settings'));
  //  If nothing is being saved in localStorage, then check for json file
  if (savedValues && typeof savedValues == 'object') {
    loadSavedValues(savedValues);
  } else postToJsonFile(settings, 'get records');
}

//  I kept this in main.js to show the flow when first starting the program
//  The values parameter is needed when saveNewSettings calls this function
export function postToJsonFile(values, action) {
  const formData = new FormData();
  for (let value in values) {
    formData.append(value, values[value]);
  }
  //  checkBoxes is a node list - this is how to iterate over it (checkboxes & radios)
  [...checkBoxes].forEach((box) => {
    //  Get the 'check' attribute for all custom aj-checkbox elements
    formData.append(box.id, box.getAttribute('check'));
  });
  formData.append('action', action);

  fetch('./php/getSettings.php', {
    method: 'POST',
    body: formData,
  })
    .then((res) => {
      console.log('returned from main.js - currently this is line 149');
      return res.json();
    })
    .then((savedValues) => {
      console.log(savedValues);
      if (savedValues.action == 'get records') loadSavedValues(savedValues);
    });
}

//  This comes from either localStorage or jsonfile
//  This also only happens once on startup
function loadSavedValues(savedValues) {
  const checkboxIds = {
    // downloadFile: '',
    // onlyCopyLinkAddress: '',
    saveSettingsLocally: '',
    saveSettingsJson: '',
    saveSettingsNone: '',

    //  Some of the saved values need to be converted to numeric values (+)
    keepFontWeight: ['weight', +savedValues.weight],
    keepFontStyle: ['style', savedValues.style],
    keepFontSize: ['size', +savedValues.size],
    keepLetterSpace: ['LSpacing', +savedValues.LSpacing],
    keepWordSpace: ['WSpacing', +savedValues.WSpacing],
    keepMargin: ['margin', +savedValues.margin],
    keepSampleText: ['currentText', savedValues.currentText],
    keepFontFam: ['fontFam', savedValues.fontFam],
  };

  for (const [key, value] of Object.entries(savedValues)) {
    if (Object.keys(checkboxIds).includes(key)) {
      //  Load checks into ALL of the checkboxes
      document.getElementById(key).setAttribute('check', value);
      // //  Apply values to the settings
      if (value == 'true' && checkboxIds[key]) {
        settings[checkboxIds[key][0]] = checkboxIds[key][1];
      }
    }
  }

  displayText();

  if (savedValues.onlyCopyLinkAddress == 'false')
    downloadFileBtn.parentElement.style.display = 'none';
}

//  prettier-ignore
function displayText() {
  //  set font family for sampleText

  const checkDisabled = [
    weightBtns.firstElementChild,
    weightBtns.lastElementChild,
    btns.fontWeightDiv,
    styleBtn.parentElement,
    newTextBtn.parentElement,
    btns.copyCss.parentElement,
    btns.copyHtml.parentElement,
    downloadFileBtn.parentElement,
  ]

  if (!settings.fontFam) {
    checkDisabled.forEach((button) => button.classList.add('disabled'));
    document.getElementById('fontName').innerText = 'Select a font from the list';
  } else {
    checkDisabled.forEach((button) => button.classList.remove('disabled'));
    document.getElementById('fontName').innerText = settings.fontFam;
  }



  //  put name of font into the heading
  sampleText.style.fontFamily = settings.fontFam;

  //   check reset settings buttons
  if (document.getElementById('keepFontWeight').getAttribute('check') == 'false') 
    settings.weight = 400;

  if (document.getElementById('keepFontStyle').getAttribute('check') == 'false') 
    settings.style = 'normal';

  if (document.getElementById('keepFontSize').getAttribute('check') == 'false') 
    settings.size = settings.defaultSize;

  if (document.getElementById('keepLetterSpace').getAttribute('check') == 'false') 
    settings.LSpacing = 0

  if (document.getElementById('keepWordSpace').getAttribute('check') == 'false') 
    settings.WSpacing = 0

  if (document.getElementById('keepMargin').getAttribute('check') == 'false') 
    settings.margin = 0

  if (document.getElementById('keepSampleText').getAttribute('check') == 'false') 
    settings.currentText = defaultSampleText

  btns.changeWeightDisplay();
  btns.setStyleProperty();
  sampleText.style.setProperty('--fontSize', settings.size + 'px');
  sampleText.style.setProperty('--letterSpacing', settings.LSpacing + 'px');
  sampleText.style.setProperty('--wordSpacing', settings.WSpacing + 'px');
  sampleText.style.setProperty('--margin', `${settings.margin}px`);
  console.log(settings.fontFam)
  if (settings.fontFam) {
    if (document.getElementById('keepSampleText').getAttribute('check') == 'false') {
      settings.currentText = defaultSampleText;
    }
    
    while(sampleText.firstChild){
      sampleText.removeChild(sampleText.firstChild);
    }
    sampleText.innerHTML = settings.currentText;
  }

  btns.toFront();
}

//  This is only done once when the program starts
fetch('./php/get_font_data.php')
  .then((res) => {
    if (res.ok) {
      return res.json();
    } else {
      console.error('%cFetch Failed!!!');
    }
  })
  .then((all_font_families) => {
    console.log(all_font_families);
    /*
                      this is useful for logging the appendCode text
  */
    // for (const family in all_font_families) {
    //   const fontFileNames = Object.values(all_font_families[family].fonts)
    //   console.log('- - --- -- - --- --')
    //   fontFileNames.forEach(name => {
    //   console.log(name.appendCode)})
    // }

    iterateFontFolders(all_font_families);
  });
//

function iterateFontFolders(fontFamilies) {
  for (const folderName in fontFamilies) {
    const dataObj = fontFamilies[folderName].overall; //         data object
    const fontFiles = fontFamilies[folderName].fonts; //         font file list

    fontInfo[folderName] = [];
    fontInfo[folderName].dataObj = dataObj;
    fontInfo[folderName].fontFiles = fontFiles;
  }

  fontInfo.sort((a, b) => {
    let fa = a.family.toLowerCase(),
      fb = b.family.toLowerCase();

    if (fa < fb) {
      return -1;
    }
    if (fa > fb) {
      return 1;
    }
    return 0;
  });

  //  If a font is already in settings on startup, add the folder name to settings
  if (settings.fontFam) {
    settings.fontFolder = fontInfo[settings['fontFam']]['dataObj']['folder'];
    createWeightsTable();
  }

  //  filesDiv node is passed instead of exported
  renderFonts(filesDiv);
}

filesDiv.onclick = (e) => {
  e.preventDefault();
  settings.fontFam = e.target.getAttribute('data-font-name');
  settings.fontFolder = fontInfo[settings.fontFam]['dataObj']['folder'];
  saveNewSettings();
  displayText();
  createWeightsTable();
};
















































let onwheelTimeout;
// prettier-ignore
function changeProperty(property) {
  //  changeProperty(['size', '--fontSize', 0, 100, 'Font Size: ']);
  //  delete sampleText.onwheel is my own hack to stop memory leaks.
  //  I have to check this further to see if it works or is obsolete.
  delete sampleText.onwheel;
  //  I read somewhere that the trash collector does not get the object created here
  sampleText.onwheel = (e) => {
    if (settings.fontFam == '') return
    //  e.deltaY  -  down is positive, up is negative
    let direction = e.deltaY > 0 ? -1 : 1;
    settings[property[0]] += +direction;
    if (settings[property[0]] < property[2])
    settings[property[0]] = property[2];
    if (settings[property[0]] > property[3])
    settings[property[0]] = property[3];
    sampleText.style.setProperty(property[1], settings[property[0]] + 'px');
    showSizeInPx(property[4], `${settings[property[0]]}px`);
    //  wait 2 seconds before saving new setting
    clearTimeout(onwheelTimeout);
    onwheelTimeout = setTimeout(saveNewSettings, 2000);
  };
}

document.querySelector('body').onkeydown = (e) => {
  const keyDown = {
    l: ['LSpacing', '--letterSpacing', 0, 30, 'Letter Spacing: '],
    w: ['WSpacing', '--wordSpacing', 0, 30, 'Word Spacing: '],
    m: ['margin', '--margin', -50, 30, 'Margin: '],
  };
  const property = keyDown[e.key];
  if (!property || settings.fontFam.length == 0 || e.repeat) return;
  changeProperty(property);
};

document.querySelector('body').onkeyup = (e) => {
  //  delete sampleText.onwheel is my own hack to stop memory leaks.
  //  I have to check this further to see if it works or is obsolete.
  delete sampleText.onwheel;
  //  No keys need to be pressed for this,
  //  ANY key up should reset wheel function to font-size
  changeProperty(['size', '--fontSize', 4, 100, 'Font Size: ']);
};

let sizeInPxTimeout;
function showSizeInPx(label, setting) {
  sizeInPxEl.innerText = `${label} ${setting}`;
  sizeInPxEl.style.visibility = 'visible';
  clearTimeout(sizeInPxTimeout);
  sizeInPxTimeout = setTimeout(() => {
    clearSizeInPx();
  }, 4000);
}

sampleText.onclick = () => {
  clearSizeInPx();
};

function clearSizeInPx() {
  sizeInPxEl.style.visibility = 'hidden';
  sizeInPxEl.innerText = '';
}




