import {
  postToJsonFile,
  fontInfo,
} from './main.js';

//  card-back - all 9 custom checkboxes are stored
export const checkBoxes = document.querySelectorAll('aj-checkbox');

//  These are for the buttons in the card-front
export const settings = {
  style: 'normal',
  weight: 400,
  fontFam: '',
  //   font size is in px's
  defaultSize: 30,
  size: 30,
  LSpacing: 0,
  WSpacing: 0,
  margin: 0,
  currentText: '',
};

//    Change text to Title Case (does same as my version); taken from Stack Overflow as answer number 7 at URL:
//    https://stackoverflow.com/questions/17450351/how-to-capitalize-first-letter-only-using-css-in-each-case

// function toTitleCase(str) {
//   return str.replace(/\w\S*/g, function (txt) {
//     return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
//   });
// }

//  My version is less confusing for anyone who does not have a solid grasp of regular expressions (regex)
export function toTitleCase(str) {
  return str
    .split(' ')
    .map((word) => {
      return word[0].toUpperCase() + word.slice(1).toLowerCase();
    })
    .join(' ');
}

//     This helper function is a little trickier than it seems
//  I needed to make 2 sets of aj-checkbox elements into radio buttons
//  since these custom buttons have no inherit radio functionality
export function initRadioBtns(radioBtns, callback) {
  for (let x = 0; x < radioBtns.length; x++) {
    radioBtns[x].onclick = () => {
      //  if radio button is already checked, then do nothing
      if (radioBtns[x].getAttribute('check') == 'true') return;
      //  Clear ALL of the radio button checks first
      radioBtns.forEach((box) => box.setAttribute('check', 'false'));
      //  Set the checked box to check = "true"
      radioBtns[x].setAttribute('check', 'true');
      callback(radioBtns[x]);
    };
  }
}

//  initialize the other 6 checkboxes
export function initCheckListeners() {
  [...document.getElementsByClassName('checkbox')].forEach((check) =>
    check.addEventListener('click', saveNewSettings)
  );
}

//   First method for loading the font into the program
export function renderFonts(filesDiv) {
  console.log(filesDiv);
  let cssDomPrepend = '';

  for (const family in fontInfo) {
    const files_de_font = fontInfo[family]['fontFiles'];
    for (const file in files_de_font) {
      cssDomPrepend += files_de_font[file].appendCode;
    }
  }

  const style = document.createElement('style');
  console.log(fontInfo);
  Object.keys(fontInfo).forEach((name) => {
    const div = document.createElement('div');
    div.classList.add('font');
    div.innerText = toTitleCase(name);
    div.style.fontFamily = `${name}`;
    div.setAttribute('data-font-name', name);
    filesDiv.appendChild(div);
  });

  document.querySelector('.grandTotal').innerText = `Font Families: ${
    Object.keys(fontInfo).length
  }`;
  const styleEl = document.createElement('style');
  styleEl.innerHTML = cssDomPrepend;
  document.getElementsByTagName('body')[0].prepend(styleEl);

  const img = new Image();
  const loadingAssets = document.getElementById('loadingAssets');
  // prettier-ignore
  img.onload = () => {
    document.fonts.ready.then(() => {
      document.getElementsByTagName('body')[0].style.setProperty('background-image', `url(${img.src})`);
      //  it keeps flipping from the settings to the sample text on start-up,
      //    This is to kelp cover that up and to make the 'please wait' message
      //       have more than a split second if it downloads fast.
      setTimeout(() => {
        loadingAssets.style.opacity = 0;
        setTimeout(() => {
          loadingAssets.remove();
        }, 500);
      }, 2000);
    });
  };

  img.onerror = function () {
    console.log('Error image index: ' + eachImage);
  };

  img.src = './images/cool_background.jpg'; // fires off loading
}

//  This updates localStorage AND the text file each time a change is made
export function saveNewSettings() {
  //  saving to localStorage is hard coded in this function
  //  A slight delay is used here to be sure custom checkbox values are changed
  setTimeout(() => {
    // const values = getAllButtonValues();
    const values = {};
    for (let x = 0; x < checkBoxes.length; x++) {
      values[checkBoxes[x].id] = checkBoxes[x].getAttribute('check');
    }
    for (const setting in settings) {
      values[setting] = settings[setting];
    }

    if (values.saveSettingsLocally === 'true')
      localStorage.setItem('settings', JSON.stringify(values));
    else localStorage.setItem('settings', null);

    let action;
    if (values.saveSettingsJson == 'true') action = 'save records';
    else if (values.saveSettingsNone == 'true') action = 'delete records';
    else if (values.saveSettingsLocally === 'true') action = 'delete records';

    //  the settings text file is deleted if it is not used
    postToJsonFile(values, action);
  }, 200);
}

export function createWeightsTable() {
  //  start by just console logging them
  const weightsAvailable = fontInfo[settings['fontFam']].dataObj.weights_styles;
  weightsAvailable.normal.sort(), weightsAvailable.italic.sort();
  const maxWeights = Math.max(
    weightsAvailable.normal.length,
    weightsAvailable.italic.length
  );

  console.log(weightsAvailable.normal);
  console.log(weightsAvailable.italic);
  console.log(maxWeights);

  //  Create Table
  const table = document.createElement('table');

  //  Create Top Row
  const th_1 = document.createElement('th');
  th_1.innerText = 'Normal';
  th_1.style.width = '50%';

  const th_2 = document.createElement('th');
  th_2.innerText = 'Italic';
  th_2.style.width = '50%';

  const tr_1 = document.createElement('tr');
  tr_1.appendChild(th_1);
  tr_1.appendChild(th_2);

  table.appendChild(tr_1);

  //  Create additional rows
  for (let x = 0; x < maxWeights; x++) {
    console.log(x);
    // console.log(weightsAvailable)

    const td_1 = document.createElement('td');
    td_1.innerText =
      x < weightsAvailable.normal.length ? weightsAvailable.normal[x] : '-';
    const td_2 = document.createElement('td');
    td_2.innerText =
      x < weightsAvailable.italic.length ? weightsAvailable.italic[x] : '-';

    const nextRow = document.createElement('tr');
    nextRow.appendChild(td_1);
    nextRow.appendChild(td_2);

    table.appendChild(nextRow);
  }

  console.log(table);
  weightsTable.innerHTML = '';
  weightsTable.appendChild(table);
}

let disableTooltipTimeout;
export function disableTooltip_7sec(buttons) {
  console.log(buttons);
  //  Tooltip(s) are disabled momentarily:
  //      Both the plus and minus buttons should be delayed in case the
  //      other button is hovered over while looking at each font weight
  buttons.forEach((button) => button.classList.add('disabled'));
  clearTimeout(disableTooltipTimeout); //  sort of a double meaning for 'Timeout'
  disableTooltipTimeout = setTimeout(() => {
    buttons.forEach((button) => button.classList.remove('disabled'));
    //  Add in the 1 second transition delay in CSS and this becomes 7 seconds
  }, 6000);
}