//  This is an awesome web component!  The color and size defaults are black and 50px, respectively. These can be changed by adding color and size attributes to the component within the html document: color="any color"  size="any unit of measure"

//  Again, the defaults are:
//          color="black"
//          size="50px"

//  A spin attribute can also be added for extra 'zing'
//          spin="yes"

//  In the HTML document, aj-burger will have an attribute of 'active'
//  when it is clicked the first time, and no attribute when clicked again.

//  A dur attribute can also be added to the html element to create a specific
//  duration so as to match the durations used in the rest of the document.
//  Otherwise, a default value of 350ms will be used.
//          dur="s or ms"

export class Hamburger extends HTMLElement {
    constructor() {
        super()
        this.attachShadow({
            mode: 'open'
        })
        //  the styles here will ONLY apply to the HTML code in
        //  this template thanks to the shadow DOM (shadowRoot)
        this.shadowRoot.innerHTML = `
        <style>
            

            .burger {
                --color: black;
                --size: 50px;
                --spin: 45deg;
                --dur: 300ms;
                position: relative;
                cursor: pointer;
                border: 1px solid var(--color);
                border-radius: 10%;
                padding: 0;
                width: var(--size);
                height: var(--size);
                transition: all var(--dur) linear;
            }

            .burger:hover {
                border: 1px solid rgb(0, 200, 0);
            }

            .burger.btn {
                box-shadow: 3px 3px 4px var(--color);
            }

            .burger.active.btn {
                box-shadow: .5px .5px var(--color);
                transform: translate(2px, 2px);
            }

            .burger.active.noButton {
                border: 1px solid rgba(var(--color), 0);
            }

            .burger span {
                position: relative;
                top: 45%;
                transform: translateY(-50%)
                left: 0;
                right: 0;
                margin: auto;
                height: 8%;
                width: 70%;
            }
            
            .burger span:before,
            .burger span:after {
                content: "";
                position: absolute;
                width: 100%;
                height: 100%;
            }

            .burger span,
            .burger span:before,
            .burger span:after
             {
                border-radius: 100px;
                background: var(--color);
                display: block;
                transition: all var(--dur) linear;
            }

            .burger:hover span,
            .burger:hover span:before,
            .burger:hover span:after
            {
                background: rgb(0, 200, 0);
            }
            
            .burger span::before {
                transform: translateY(-290%);
                transition: background 0s;
            }
            
            .burger span::after {
                transform: translateY(290%);
            }
            
            .burger.active span {
                background: transparent;
                box-shadow: none;
            }

            .burger.active span:before,
            .burger.active span:after {
                transform: translateY(0);
            }
          
            .burger.active span:before {
              transform: rotate(var(--spin));
            }
          
            .burger.active span:after {
              transform: rotate(calc(var(--spin) * -1));
            }
            
            
        </style>
        <div class="burger noButton">
            <span></span>
        </div> `

        this.burger = this.shadowRoot.querySelector(".burger");
    }

    connectedCallback() {
        const color = this.getAttribute('color')
        const size = this.getAttribute('size')
        const spin = this.hasAttribute('spin')
        const dur = this.getAttribute('dur')
        const btn = this.hasAttribute('button')
        if (color) { this.burger.style.setProperty('--color', color) }
        if (size) { this.burger.style.setProperty('--size', size) }
        if (spin) { this.burger.style.setProperty('--spin', '-225deg') }
        if (dur) { this.burger.style.setProperty('--dur', dur) }
        if (btn) {
            this.burger.classList.add('btn')
            this.burger.classList.remove('noButton')
        }

        this.addEventListener("click", () => {
            this.burger.classList.toggle("active");
            this.classList.toggle("active")
        });
    }

}
