export { init, toFront };

const cardBackEl = document.querySelector('.card-back');
const cardFrontEl = document.querySelector('.card-front');
//  This initializes the onclick for each side of the card
function init() {
  //  //  //                  SPIN
  //  This spins so the instructions are showing
  document.querySelector('.seeInst').onclick = () => {
    document.querySelector('#innerMain').style.animation =
      'spin_1a 1s linear forwards';
    document.querySelector('#innerBackMain').style.animation =
      'spin_2a 1s linear forwards';
  };

  //  This spins so the front is showing
  document.querySelector('.spinBackward').onclick = () => {
    const burger = document.querySelector('aj-burger');
    if (burger.classList.contains('active')) burger.click();
    document.querySelector('#innerMain').style.animation =
      'spin_2b 1s linear backwards';
    document.querySelector('#innerBackMain').style.animation =
      'spin_1b 1s linear backwards';
  };

  //  //  //                  FLIP
  //  This flips so the back is showing
  document.querySelector('.flipForward').onclick = () => {
    cardFrontEl.style.animation = 'flip_1a 1s linear forwards';
    cardBackEl.style.animation = 'flip_2a 1s linear forwards';
    cardBackEl.style.visibility = 'visible';
  };

  //  This flips so the front is showing
  document.querySelector('.flipBackward').onclick = () => {
    toFront();
  };
}

//  When the settings are displayed and a new font is clicked...
//   then the card flips automatically to show the new font.
function toFront() {
  setTimeout(() => {
    cardBackEl.style.visibility = 'hidden';
  }, 900);
  cardFrontEl.style.animation = 'flip_2b 1s linear backwards';
  cardBackEl.style.animation = 'flip_1b 1s linear backwards';
}


import Checkbox from './aj_checkbox.js';
customElements.define('aj-checkbox', Checkbox);
import { Hamburger } from './hamburger.js';
const burger = document.getElementById('aj-burger');
burger.addEventListener('click', () => {
  document
    .getElementById('instructionMenuContainer')
    .classList.toggle('active');
});

[...document.getElementsByClassName('menuItem')].forEach((li) => {
  li.addEventListener('click', () => burger.click());
});

customElements.define('aj-burger', Hamburger);





import { fontInfo } from './main.js';

import {
  settings,
  saveNewSettings,
  disableTooltip_7sec,
  // checkBoxes,
  // initRadioBtns,
  // initCheckListeners,
  // renderFonts,
  // downloadFile,
  // createWeightsTable,
} from './helpers.js';

import { downloadFile } from './fetch.js';


//  card-front - buttons
const weightBtns = document.getElementById('weightBtns');
export const fontWeightDiv = document.getElementById('fontWeightBtn');
const styleBtn = document.getElementById('styleBtn');
const newTextBtn = document.getElementById('newTextBtn');
export const copyCss = document.getElementById('copyCssToClipBtn');
export const copyHtml = document.getElementById('copyHtmlToClipBtn');



//  When the font weight is changed (- or +), the cursor might need
//   to hover over the button while looking at each font weight, and
//    before changing it again; and so these tooltips are delayed.
weightBtns.onclick = (e) => {
  //  Display tooltip and return if no font family is selected
  if (settings.fontFam == '') {
    pickAFontFirst();
    return;
  }

  //  There are only three possible buttons: plusBtn, minusBtn, fontWeightBtn
  const targetId = e.target.id;
  if (targetId == 'plusBtn' || targetId == 'minusBtn') {
    if (targetId == 'plusBtn') {
      settings.weight =
        settings.weight < 900 ? (settings.weight += 100) : settings.weight;
    } else {
      settings.weight =
        settings.weight > 100 ? (settings.weight -= 100) : settings.weight;
    }

    changeWeightDisplay();
    saveNewSettings();
    disableTooltip_7sec([
      weightBtns.firstElementChild,
      weightBtns.lastElementChild,
    ]);
  } else if (targetId == 'fontWeightBtn') {
    //  The #fontWeightBtn div is the number between the + and - signs
    displayWeights();
    disableTooltip_7sec([fontWeightDiv]);
  }
};


function displayWeights() {
  console.log(weightsTable.style.display);

  if (weightsTable.style.display == 'block') {
    weightsTable.style.display = 'none';
    sampleText.style.left = '0';
    sampleText.style.width = '100%';
  } else {
    sampleText.style.left = '120px';
    sampleText.style.width = 'calc(100% - 120px)';
    setTimeout(() => {
      weightsTable.style.display = 'block';
    }, 100);
  }
}

export function changeWeightDisplay() {
  console.log(settings.weight);
  sampleText.style.fontWeight = settings.weight;
  fontWeightDiv.innerText = settings.weight;
}

styleBtn.onclick = () => {
  //  Don't change style if a font has not been picked yet
  if (settings.fontFam == '') {
    pickAFontFirst();
    return;
  }

  disableTooltip_7sec([styleBtn.parentElement]);
  settings.style = settings.style == 'normal' ? 'italic' : 'normal';
  setStyleProperty();
};

//  This function is also called if italic is reset when loading a new font
export function setStyleProperty() {
  sampleText.style.fontStyle = settings.style;
  styleBtn.style.fontStyle = settings.style;
  styleBtn.innerText = settings.style;
  saveNewSettings();
}


newTextBtn.onclick = () => {
  //  Don't enter new text if a font has not been picked yet
  if (settings.fontFam == '') {
    pickAFontFirst();
    return;
  }

  //  disable the toolTip and change the top message to explain down arrow and enter
  const textBtnParent = newTextBtn.parentElement;
  textBtnParent.classList.add('disabled');
  topMsg.innerHTML = document.querySelector('template.instructions').innerHTML;

  sampleText.innerHTML = `<textarea></textarea>`;
  const textArea = sampleText.querySelector('textarea');
  textArea.focus();
  textArea.onkeydown = (e) => {
    if (e.key == 'Enter') {
      e.preventDefault();
      e.stopPropagation();
    }
  };

  textArea.onkeyup = (e) => {
    if (e.key == 'Enter') {
      textArea.onblur = null;
      enterNewText(textArea.value.trim());
    }
    if (e.key == 'ArrowDown') textArea.value += '\n';
  };
  textArea.onblur = () => {
    enterNewText(textArea.value.trim());
  };

  function enterNewText(text) {
    console.log('- - - - ---  - --- - - --');
    console.log(text);
    console.log(sampleText.innerHTML);
    //  reset top message to font name and scroll instructions
    topMsg.innerHTML = document.querySelector('template.topMsg').innerHTML;
    //  css gives the first child visibility = 'hidden'
    //  when the template is re-loaded, this child needs to be visible again.
    topMsg.querySelector('#fontName').innerText = settings.fontFam;

    //  text area is 'deleted', so listeners no longer exist
    while (sampleText.firstChild) {
      sampleText.removeChild(sampleText.firstChild);
    }

    text = text == '' ? settings.currentText : text.replaceAll(' ', '&nbsp');
    text = '<div>' + text.replaceAll(`\n`, '</div><div>') + '</div>';
    console.log(text);
    sampleText.innerHTML = text;
    settings.currentText = text;
    disableTooltip_7sec([textBtnParent]);
    console.log(sampleText.innerHTML);
    saveNewSettings();
  }
};

//  div argument is the tooltip to be displayed
//     - tooltip is applied to the parent element
let flashing;
function pickAFontFirst() {
  //  make the top message flash ('Select a font from the list')
  let flash = 0;
  const fontName = document.getElementById('fontName');
  fontName.style.opacity = 0;
  clearInterval(flashing);
  flashing = setInterval(() => {
    flash++;
    fontName.style.opacity = flash % 2;
    if (flash == 3) clearInterval(flashing);
  }, 500);
}

copyHtml.onclick = () => {
  copyCodeToClip(
    `HTML`,
    [`\<!--`, `-->`, `\<style>\n`, `\</style>\n`],
    copyHtml
  );
};

copyCss.onclick = () => {
  copyCodeToClip('CSS', [`/*`, `*/`, '', ''], copyCss);
};

//  prettier-ignore
function copyCodeToClip(language, code, button) {
  
  if (settings.fontFam == '') {
    pickAFontFirst()
    return
  };

  disableTooltip_7sec([button.parentElement])
  
  //  get font face data from the overall object (data_overall.json)
  const fontFaceRules = fontInfo[settings.fontFam]['dataObj'].appendFontFam
  // const numOfFaces = fontFaceRules.includes(fontFaceRules)
  const numOfFaces = fontFaceRules.split("@font-face").length - 1;

  const extra_text = (numOfFaces > 1) ?
  `        Deciding which fonts to use is as easy as commenting and\n` +
  `        un-commenting each $font-face rule below. It is advised\n` +
  `        to comment out any weights/styles that are not needed.\n` : ''

  const comment = {
    start: code[0],
    end: code[1]
  }

    //  put quotes around font family name if there is more than one word.
  const quote = (settings.fontFam.trim().split(' ').length > 1) ? "'" : ""

    //   provide some comment text for documentation
  const whereToCopy = language == 'CSS' ? 'start of your css' : 'head of your html'
  let text =
    `${comment.start}\n` +
    `    This code should already be copied to the ${whereToCopy}. Download the font files\n` +
    `    by clicking the 'FILE' button, then extract all of the contents into whichever file\n` +
    `    you use for fonts ('google-font', in this case). Depending on your file system, adjust\n` +
    `    the relative URL by starting with the ${language} file this code is entered into as the root..\n\n` +
    `    The most recent settings were:\n\n` +
    `        div {\n` +
    `          font-family: ${quote}${settings.fontFam}${quote};\n` +
    `          font-size: ${settings.size}px;\n` +
    `          letter-spacing: ${settings.LSpacing}px;\n` +
    `          word-spacing: ${settings.WSpacing}px;\n` +
    `          margin: ${settings.margin}px;\n` +
    `          font-weight: ${settings.weight}px;\n` +
    `          font-style: ${settings.style};\n` +
    `        }\n\n` 
  //


  text += extra_text
  text +=`${comment.end}\n`;

  text += `${code[2]}${fontFaceRules}${code[3]}`;

  // console.clear()
  // console.log(text)

  navigator.clipboard.writeText(text);

  let copiedDiv = document.querySelector(
    '#' + language.toLowerCase() + 'Copied'
  );
  successTip(copiedDiv, button);  
}

downloadFileBtn.onclick = () => {
  if (settings.fontFam == '') {
    pickAFontFirst();
    return;
  }
  disableTooltip_7sec([downloadFileBtn.parentElement]);
  downloadFile(settings.fontFolder);
};

function successTip(div, button) {
  div.style.display = 'block';
  // document.transition = 'transform 0s 0s'
  setTimeout(() => {
    div.style.display = 'none';
  }, 1500);  
  setTimeout(() => {
    button.parentElement.classList.remove('disabled');
  }, 4000);  
}  