export default class Checkbox extends HTMLElement {
  constructor() {
    super();
    this.border = this.getAttribute('data-bordercolor');
    this.border = this.border ? this.border : 'black';
    this.type = this.getAttribute('type');
    this.label = this.getAttribute('data-label');
    this.shadow = this.attachShadow({
      mode: 'open',
    });
    this.shadow.innerHTML = `
      <style>
        * {
          box-sizing: border-box;
          margin: 0;
          padding: 0;
          letter-spacing: .04vw;
        }

        :host {
          width: 100%;
          height: min-content;
        }

        .container::before {
          content: "";
          position: absolute;
          top: 0;
          bottom: 0;
          left: 0;
          right: 0;
          height: 100%;
          background: hsla(10, 50%, 100%, 1);
          z-index: -1;
        }

        .container:hover::before {
          background: hsla(10, 50%, 100%, .17);
        }

        .container {
          width: fit-content;
          height: min-content;

          position: relative;
          color: inherit;
          border: 0;
          cursor: pointer;
        }

        img {
          position: relative;
          width: 15px;
          height: auto;
          top: 0;
          left: 0
          transform: translateX(55%);
        }

        label {
          position: relative;
        }
        
        .box {
          position: absolute;
          height: 12px;
          width: 12px;
          border: 1px solid ${this.border};        
          top: 4px;
          left: 0;           
        }

        #clickCatcher {
          position: absolute;
          top: 0;
          bottom: 0;
          left: 0;
          right: 0;
          background: transparent;
        }
        
      </style>

      <div for="input" class="container">
        <div id="label">
          <img id="checkImage" alt="check box ${this.label}">
          ${this.label}
          <div class="box"></div>
        </div>
        <div class="${this.class}" id="clickCatcher"></div>
      </div>        
    `;
    this.checkMark = this.shadow.querySelector('img');
    this.container = this.shadow.querySelector('.container');

    //  src="./images/check_mark_images/fancy_green.png"
    this.shadow.getElementById('checkImage').src =
      this.getAttribute('data-color') == 'black'
        ? './images/check_mark_images/img_174447.png'
        : './images/check_mark_images/fancy_green.png';
  }

  connectedCallback() {
    //  Check is added to collect form data
    //  if this component is ever extended

    //  original default 'check' attribute is set from outside this
    //  custom element so that it doesn't interfere with listeners

    //  onclick is NOT listened for with custom radio buttons,
    //  radio button functionality is done with JS functions
    if (this.type === 'checkBox') {
      this.onclick = () => {
        const newValue =
          this.getAttribute('check').toLowerCase() == 'true' ? 'false' : 'true';
        this.setAttribute('check', newValue);
      };
    }
  }

  static get observedAttributes() {
    return ['check'];
  }

  attributeChangedCallback(prop, oldVal, newVal) {
    if (newVal == 'true') {
      this.checkMark.style.visibility = 'visible';
    } else {
      this.checkMark.style.visibility = 'hidden';
    }
  }
}

//  this is declared in main.js
//  customElements.define('aj-checkbox', Checkbox);
