<?php
session_start();
include_once('./createCode.php');
// function createText($files) {
//   return $files;
// }

//   The directory folder and all accepted font types are set once here so 
//    they won't need to be changed anywhere else (like, get_zipped.php)
//  At the time this writing the main folder was $dir = 'font_folder'
// $_SESSION['mainFontFolder'] = 'google_fonts_test';
$_SESSION['mainFontFolder'] = 'font_folder';
$_SESSION['supported fonts'] = ['.ttf', '.woff', '.woff2'];
//  Some font types, like variable fonts, are not yet supported in this program.
$_SESSION['fonts being considered'] = ['.eot', '.otf'];


//  Initialize the directory the fonts are an and the array that will be returned as json
$dir = $_SESSION['mainFontFolder'];
$arr = [];

//           array_diff(array1, array2 [optional: array3, and so on...])
//  compares the values of two (or more) arrays, and returns an array that contains
//     the entries from array1 that are not present in array2 or array3, etc.
$families = array_diff(scandir('../' . $dir . '/'), array('.', '..'));

//  This iterates all font-family folders (regardless of font-name)
foreach ($families as $family_folder) {

  $familyURL = '../' . $dir . '/' . $family_folder;

  // Conditions for skipping this font family
  if (
    !is_dir($familyURL) ||  //  skip if it is not a directory
    !file_exists($familyURL . '/data_overall.json') ||  //  skip if this file isn't in it
    $family_folder === '__zzz'  //  DON"T include the __zzz folder
  ) continue;

  //  Store ALL of the data for each family in $this_family
  $this_family = [];

  //  First: get the overall json data for that family
  $data_overall = (array) json_decode(file_get_contents($familyURL . '/data_overall.json'));
  //  The folder: property is set here (not in data_overall.json) in case the folder name is changed
  $data_overall['folder'] = $family_folder;
  $this_family['overall'] = $data_overall;
  //

  //  Second: get the folders for all font sizes/styles
  $this_family['fonts'] = [];
  $files = array_diff(scandir($familyURL), array('.', '..'));
  $copyToClip = '';
  $weights_and_styles = [];
  $weights_and_styles['italic'] = [];
  $weights_and_styles['normal'] = [];

  foreach ($files as $subFolder) {
    //  Make sure it is a folder  ...&&... the data.json file exists
    if (!is_dir($familyURL . '/' . $subFolder) || !file_exists($familyURL . '/' . $subFolder . '/data.json')) continue;

    $font = array_values(array_diff(scandir($familyURL . '/' . $subFolder), ['.', '..']));

    //                    strripos(string1, string2)
    //  find the position of the last occurrence of string2 inside string1
    $filtered_files = array_filter($font, function ($check_file) {
      $check_file_ext = strtolower(substr($check_file, strripos($check_file, '.')));
      return (in_array($check_file_ext, $_SESSION['supported fonts']));
    });

    //  Get data.json for each font within the family
    $data = (array) json_decode(file_get_contents($familyURL . '/' . $subFolder . '/data.json'));
    array_unshift($weights_and_styles[$data['style']], $data['weight']);

    //  $filtered_files holds all the supported font files
    //  $data holds the size and style along with css and html links

    $all_font_info = [];
    if (sizeof($filtered_files) && !is_object($filtered_files) && sizeof($data)) {
      $all_font_info['File Names'] = [...$filtered_files];
      foreach ($data as $key => $value) {
        $all_font_info[$key] = $value;
      }
      $font_face = create_appendCode($data_overall['name'], $family_folder, $subFolder,  $all_font_info);
      $all_font_info['appendCode'] = $font_face;
      $copyToClip .= $font_face;
      // array_push($this_family['fonts'], $all_font_info);
      $this_family['fonts'][$subFolder] = $all_font_info;
    }
  };

  $this_family['overall']['appendFontFam'] = $copyToClip;
  $this_family['overall']['weights_styles'] = $weights_and_styles;

  $arr[$data_overall['name']] = $this_family;
}

// echo json_encode(['Function Error']);
// exit();
echo json_encode($arr);
exit();
