<?php
$settingsArray = filter_input_array(INPUT_POST);

if (
  $settingsArray['action'] !== 'save records' &&
  $settingsArray['action'] !== 'get records' &&
  $settingsArray['action'] !== 'delete records'
) {
  echo json_encode(['Function Error in PHP-']);
  exit();
}

//    Possible actions are:
//        'get records'
//        'save records'
//        'delete records'

$fileURL = "./settings.json";

if ($settingsArray['action'] === 'get records') {
  //  if records are only being retrieved: this only happens once
  if (file_exists($fileURL)) {
    //    if a text file exists, then get the data
    $settingsArray = (array) json_decode(file_get_contents($fileURL, json_encode($settingsArray)));
    //  $settingsArray['action'] will be 'save records' from when it was saved last
    $settingsArray['action'] = 'get records';
    echo json_encode($settingsArray);
    exit();
  }
} else if ($settingsArray['action'] === 'save records') {
  // echo json_encode('save or whatever...');
  // exit();
  $array = (array) $settingsArray;
  file_put_contents($fileURL, json_encode($settingsArray, JSON_PRETTY_PRINT));
} else if ($settingsArray['action'] === 'delete records') {
  //  delete the text file
  if (file_exists($fileURL))
    unlink($fileURL);
}

echo json_encode($settingsArray);
exit();
