<?php
session_start();

//  delete all left over files from zip_files
foreach (array_diff(scandir('../zip_files'), ['.', '..']) as $file) {
  unlink('../zip_files/' . $file);
}

$zipFile_name = "source_code";
$zip_path = "../zip_files/$zipFile_name.zip";
$zip = new ZipArchive;
//  $zipFile_name gets returned as the name of the zip-file
$files = [];




if (!$zip->open($zip_path, ZipArchive::CREATE) === TRUE) {
  echo json_encode(['not zipped']);
  exit();
}


function addFilesFromFolders($newFolder, $zip_arch)
{
  $contents = array_diff(scandir('../' . $newFolder), ['.', '..']);
  foreach ($contents as $content_item) {
    if ($content_item == '__zzz') continue;
    if (!is_dir('../' . $newFolder . '/' . $content_item)) {
      $zip_arch->addFile(
        "../" . $newFolder . '/' . $content_item,
        'font_browser/' . $newFolder . '/' . $content_item
      );
    } else if (is_dir('../' . $newFolder . '/' . $content_item)) {
      addFilesFromFolders($newFolder . '/' . $content_item, $zip_arch);
    }
  }
}

$folders = ['php', 'scripts', $_SESSION['mainFontFolder'], 'images', 'styles'];
foreach ($folders as $folder) {
  addFilesFromFolders($folder, $zip);
};

// echo $zip_path;
// exit();

$notFolders = ['index.html'];
foreach ($notFolders as $file) {
  $zip->addFile('../'.$file, 'font_browser/' . $file);
}

$zip->close();
echo $zipFile_name;
exit();
